/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.log;

import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigExposedFieldPanel;
import filenet.vw.toolkit.admin.property.base.VWConfigGeneralPane;
import filenet.vw.toolkit.admin.property.base.VWConfigIndexPane;
import filenet.vw.toolkit.admin.property.base.VWConfigSystemFieldPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWConfigLogPropertyDialog
extends VWModalDialog
implements ActionListener,
ChangeListener {
    private static int ON_ALL_SERVERS = -1;
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private VWConfigGeneralPane m_generalPane = null;
    private VWConfigSystemFieldPanel m_sysExposedFieldsPane = null;
    private VWConfigExposedFieldPanel m_userExposedFieldsPane = null;
    private VWConfigIndexPane m_indexTablePane = null;
    private JButton m_OKButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JLabel m_eventLogName = new JLabel();
    private Frame m_parentFrame = null;
    private VWLogDefinition m_eventLogDefinition = null;
    private int m_nRetStatus = 1;

    public VWConfigLogPropertyDialog(Frame parent, VWSession session, VWSystemConfiguration sysConfig, VWLogDefinition eventLogDef) {
        super(parent);
        try {
            this.m_parentFrame = parent;
            this.m_eventLogDefinition = eventLogDef;
            this.setTitle(VWResource.EventLogProperties);
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension("715,495");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            Font aFont = this.getFont();
            Font boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            this.m_tabbedPanel.setFont(boldFont);
            this.m_generalPane = new VWConfigGeneralPane(this.m_eventLogDefinition.getName(), VWResource.EventLog, null, ON_ALL_SERVERS, this.m_eventLogDefinition.getDescription());
            this.m_tabbedPanel.add(VWResource.General, this.m_generalPane);
            VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, this, VWResource.LogPropertiesTabbedPane, VWResource.LogPropertiesTabbedPane);
            this.m_sysExposedFieldsPane = new VWConfigSystemFieldPanel(this.m_parentFrame, session, this.m_eventLogDefinition);
            this.m_tabbedPanel.add(VWResource.SystemFields, this.m_sysExposedFieldsPane);
            this.m_userExposedFieldsPane = new VWConfigExposedFieldPanel(this.m_parentFrame, sysConfig, session.getDatabaseType(), this.m_eventLogDefinition, 0);
            this.m_tabbedPanel.add(VWResource.DataFields, this.m_userExposedFieldsPane);
            this.m_indexTablePane = new VWConfigIndexPane(this.m_parentFrame, this.m_eventLogDefinition);
            this.m_tabbedPanel.add(VWResource.Indexes, this.m_indexTablePane);
            this.m_tabbedPanel.setSelectedIndex(0);
            this.m_tabbedPanel.addChangeListener(this);
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.m_tabbedPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_generalPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_sysExposedFieldsPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_userExposedFieldsPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_indexTablePane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean isModified() {
        return this.m_generalPane.isModified() || this.m_sysExposedFieldsPane.isModified() || this.m_userExposedFieldsPane.isModified() || this.m_indexTablePane.isModified();
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_eventLogDefinition = null;
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.removeAll();
            this.m_tabbedPanel = null;
        }
        if (this.m_generalPane != null) {
            this.m_generalPane.releaseResources();
            this.m_generalPane = null;
        }
        if (this.m_sysExposedFieldsPane != null) {
            this.m_sysExposedFieldsPane.releaseResources();
            this.m_sysExposedFieldsPane = null;
        }
        if (this.m_userExposedFieldsPane != null) {
            this.m_userExposedFieldsPane.releaseResources();
            this.m_userExposedFieldsPane = null;
        }
        if (this.m_indexTablePane != null) {
            this.m_indexTablePane.releaseResources();
            this.m_indexTablePane = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        if (this.m_eventLogName != null) {
            this.m_eventLogName.removeAll();
            this.m_eventLogName = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_nRetStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            this.stopEditing();
            this.m_eventLogDefinition.setDescription(this.m_generalPane.getDescription());
            this.m_nRetStatus = 0;
            this.setVisible(false);
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc061.htm");
        }
    }

    public void stateChanged(ChangeEvent event) {
        Component aComponent;
        Object sourceObject = event.getSource();
        if (sourceObject == this.m_tabbedPanel && (aComponent = this.m_tabbedPanel.getSelectedComponent()) == this.m_indexTablePane) {
            this.stopEditing();
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 6, 6));
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, buttonPanel, VWResource.OK, VWResource.OK);
            this.m_OKButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_OKButton);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.Cancel, VWResource.Cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, buttonPanel, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void stopEditing() {
        this.m_sysExposedFieldsPane.stopEditing();
        this.m_userExposedFieldsPane.stopEditing();
    }
}

